/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.Data;
using System.Collections;
using System.Collections.Specialized;
using Borland.Eco.Persistence;
using Borland.Eco.Persistence.Configuration;
using Borland.Eco.DataRepresentation;

namespace Borland.Eco.Persistence.Connection
{
	public interface IDatabase
	{
		void StartTransaction();
		void Commit();
		void RollBack();
		void Open();
		void Close();
		IQuery GetQuery();
		void ReleaseQuery(IQuery query);
		IExecQuery GetExecQuery();
		void ReleaseExecQuery(IExecQuery query);
		void ReleaseCachedObjects();
		StringCollection AllTableNames(string pattern, bool systemTables);
		bool TableExists(string tableName);
		DataTable GetIndexDefsForTable(string tableName);

		bool Connected { get; }
		bool InTransaction { get; }
		IDbConnection DbConnection { get; }
		DateTime OpenSince { get; }
		void DisposeConnection();
		SqlDatabaseConfig Config { get; }
	}

	public interface ITransactionable
	{
		bool PerformUpdate(object operationParams);
	}

	public interface ITransactionManager
	{
		void PerformOperationInTransaction(object context, ITransactionable callback, IDatabaseCollection databases);
	}

	public interface IDatabaseCollection: IEnumerable
	{
		IDatabase GetDatabase(string name);
		StringCollection GetNames();
		ITransactionManager TransactionManager { get; }
	}

	public class DatabaseCollection: IDatabaseCollection
	{
		private Hashtable m_InternalList = new Hashtable();
		public IDatabase GetDatabase(string name)
		{
			return m_InternalList[name] as IDatabase;
		}
		public void Add(IDatabase db, string name)
		{
			m_InternalList[name] = db;
		}
		public IEnumerator GetEnumerator()
		{
			return m_InternalList.Values.GetEnumerator();
		}
		public StringCollection GetNames()
		{
			StringCollection res = new StringCollection();
			foreach (string s in m_InternalList.Keys)
				res.Add(s);
			return res;
		}
		public bool HandlesTransactions
		{
			get
			{
				return TransactionManager != null;
			}
		}

		public DatabaseCollection(ITransactionManager transactionManager)
		{
			m_TransactionManager = transactionManager;
		}
		private ITransactionManager m_TransactionManager;
		public ITransactionManager TransactionManager { get {return m_TransactionManager;}}
	}

	public interface IField
	{
		bool IsNull { get; }
		object Value { get; }
		System.Int16 AsInt16 { get; }
		System.Int32 AsInt32 { get; }
	}

	public interface IDataSet
	{
		IField FieldByName(string fieldName);
		void Close();
		void Next();
		void Open();
		int MoveBy(int distance);
		bool Eof { get; }
		int FieldCount { get; }
		IField this[int index] { get; }
	}

	public interface IParameterized
	{
		void ClearParams();
		System.Data.IDataParameter ParamByName(string value);
	}

	public interface IQueryBase: IParameterized
	{
		void AssignSqlText(string sql);
		string SqlText { get; }
	}

	public interface IExecQuery: IQueryBase
	{
		void StartSqlBatch();
		void EndSqlBatch();
		void FailSqlBatch();
		void ExecSql();
		int RowsAffected { get; }
	}

	public interface IQuery: IQueryBase, IDataSet
	{
	}

}
